log using "C:\Users\39393\Desktop\EMANUELE\PoliTo\Tesi magistrale\Dati per STATA/DO FILE.log"

* descrizione dei dati
des 
sum

* Plot dei dati direttamente nella finestra dei risultati 
scatter  index positivit

* count
count if positivit<0.0515

sum positivit if positivit<0.0515
sum positivit if positivit>=0.0515

sum  index if positivit<0.0515
sum index if positivit>=0.0515

sum  index if positivit<0.0515, detail
sum index if positivit>=0.0515, detail

* facciamo lo scatter delle osservazioni in base al valore di positivit
scatter index positivit if positivit<0.0515
scatter index positivit if positivit>=0.0515
twoway (scatter index positivit if positivit<0.0515) (scatter index positivit if positivit>=0.0515)


* vediamo il dettaglio del comando summarize
sum index positivit, detail
** Skewness: indice di asimmetria. Se = 0 --> Simmetria
** Kurtosis: appiattimento/allungamento rispetto al valore medio (Pearson). Se > 0 pi appuntita (leptocurtosi). Se < 0 pi appiattita (platicurtosi)

* verifichiamo graficamente la kurtosis e la skewness
* istogramma
hist index, freq
hist positivit, freq
hist positivit if(positivit>0.0515), freq

kdensity index, normal
kdensity positivit, normal
kdensity positivit if(positivit>0.0515), normal

* tabelle descrittive. * Dai men: STATISTICS --> SUMMARIES,... --> TABLES --> TABSTAT
tabstat positivit index, statistics( mean sd p10 p25 p50 p75 p90 ) columns(variables)
tabstat positivit index, statistics( mean sd p10 p25 p50 p75 p90 ) columns(stats)


* Calcoliamo le stesse statistiche per il campione ridotto
tabstat positivit index, statistics( mean sd p10 p25 p50 p75 p90 ) columns(stats), if(positivit<0.0515)
tabstat positivit index, statistics( mean sd p10 p25 p50 p75 p90 ) columns(stats), if(positivit>=0.0515)

* calcoliamo la correlazione tra str e testscr
corr  index positivit
corr index positivit, means
corr index positivit if(positivit>0.0515), means

* generiamo una variabile dummy (dicotomica) dum_small in cui troveremo 1 dove la variabile positivit presenta valori inferiori a 0.0515; 0 altrove
* 0  il gruppo grande (>=0.0515 studenti); 1  il gruppo piccolo
gen dum_small=positivit<0.0515
edit positivit dum_small 
tab dum_small
* creiamo due grafici con le distribuzioni a confronto e vediamo se notiamo gi una relazione
scatter index positivit, by(dum_small)

* guardiamo il comando che ci consente di fare il test
help ttest

* facciamo un test t che confronti le medie ottenute nel test dai due gruppi definiti con la variabile dum_small. I due gruppi (con alto o basso tasso di positivit) hanno medie uguali?
* Stata genera la differenza con il segno -. Questo perch il test  costruito facendo la differenza delle medie gruppi come: media del gruppo 0-media del gruppo 1, cio nel nostro esempio media del gruppo formato da classi grandi e 1 classi formate da pochi studenti
ttest index, by(dum_small)
* rigettiamo h0, test bidirezionale (risultato centrale). Accettiamo l'ipotesi alternativa che le medie siano statisticamente differenti.
* guardiamo i risultati dei test proposti. Rigettiamo H0 anche quando l'ipotesi alternativa  che la media nei testscore delle classi grandi  inferiore alla media nei testscore delle classi piccole. Risultato a sinistra (test monodirezionale)
* (Ha: diff<0)

***********************************************************

*Regressione e previsione degli errori della regressione per gli errori eteroschedastici.

regress index positivit, robust

* mostriamo il risultato su un grafico NB: aaplot va scaricato con il comando:

ssc install aaplot

aaplot index positivit
aaplot index positivit, lopts(lc(blue)) aformat(%04.3f) bformat(%06.5f) rmseformat(%4.3f)

aaplot index positivit if positivit>0.0515
aaplot index positivit if positivit>0.0515, lopts(lc(blue)) aformat(%04.3f) bformat(%06.5f) rmseformat(%4.3f)

* salviamo i dati della regressione in un doc
outreg2 using "C:\Users\Greta\ownCloud\POLITO\2020-2021\EFI\Materiale EFI - Econometria2020\2020_GRE\DO_LOG_2020\prova.doc", replace

* Costruiamo gli errori per capire come funziona la regressione.
* Calcoliamo gli errori con il comando predict, fare il predict subito dopo aver stimato la reg
* "resid" come opzione ci consente di stimare gli errori della regressione per ogni osservazione
predict errori, resid
* Facciamo il predict dei valori di testscr attravwerso il comando predict
predict index_prev
* Generiamo una variabile differenza tra i valori empirici e quelli previsti dal modello
gen errori_man=index-index_prev
* Guardiamo le variabili testscr; testscr_prev; errori; errori_man
edit index index_prev errori errori_man
* Facciamo il plot del valori fittati. Costruisco in sostanza il grafico che ottengo con il comando aaplot
twoway (scatter index positivit) (scatter  index_prev positivit) 

* Vediamo se i risultati cambiano considerando le classi piccole
regress index positivit if positivit>0.0515, robust
* gen dum_small=str<20
regress index positivit if dum_small==0, robust 

* per cancellare
* drop dum_small

* facciamo un plot semplice. Diversit da scatter
plot index positivit

*disegnamo i dati
scatter index positivit

*Inseriamo pi di un grafico
twoway (scatter index positivit) (lfit index positivit, estopts(robust))

* Disegnamo anche gli intervalli di confidenza
twoway (scatter index positivit) (lfitci index positivit, estopts(robust))

* Facciamo un plot considerando i due campioni suddivisi in base al valore di STR
aaplot  index positivit if positivit<0.0515
aaplot  index positivit if positivit>0.0515
scatter index positivit, by(dum_small)

******************************************************

kdensity errori, normal
kdensity index_prev, normal
* verifichiamo se sono distribuiti secondo una normale pnorm=Standardized normal probability plot
pnorm errori

* twoway (kdensity errori) (kdensity testscr_prev)
sum errori, detail
sum index_prev, detail

********************************

* come cambia il commento e il calcolo se usiamo variabili dummy? 0 sono le classi grandi; 1 le piccole

sum index if dum_small==0
sum index if dum_small==1
reg index dum_small, robust

********************************

** inseriamo nella regressione la variabile X
** Variabile omessa se:
* 1) determinante di y
* 2) determinante di x
sum newcasimln, detail
corr(index newcasimln), means
corr(positivit newcasimln), means
* tabelle descrittive. * Dai men: STATISTICS --> SUMMARIES,... --> TABLES --> TABSTAT
tabstat newcasimln, statistics( mean sd p25 p50 p75 ) columns(variables)
tabstat newcasimln, statistics( mean sd p25 p50 p75 ) columns(stats)

**** Come cambia il valore del Beta di STR (_b[STR])  dopo l'inclusione di el_pct

reg index positivit newcasimln if newcasimln>200, robust

*
corr( enrl_tot comp_stu expn_stu str avginc el_pct)
corr(expn_stu str)
scatter  str expn_stu
reg testscr str expn_stu, robust
reg testscr str, robust

********************************

***** Test di 2 restrizioni su 2 coefficienti

***** Verifico se le risorse investite nella scuola influenzano l'apprendimento

regress testscr str expn_stu el_pct, robust
test str expn_stu

**** Il test rifiuta l'ipotesi nulla che entrambi i coefficienti siano nulli
**** Quindi le risorse investite nella scuola "contano"

***** Confronto il test effettutato su stime robuste e non robuste all'etroschedasticit 

regress testscr str expn_stu el_pct 
test str expn_stu
regress testscr str expn_stu el_pct, robust
test str expn_stu

*** La statistica F della stima non robusta  maggiore dell'F della stima robusta 
*** Quindi il test con la stime non robusta mi fa rifiutare l'ipotesi nulla anche quando non posso  

**** Test di una restrizione su pi coefficienti

***** Primo metodo: trasformazione dell'equazione 
**** Test di una restrizione su pi coefficienti

***** H0: str=expn_stu? 

**** Secondo metodo: verifico direttamente col test di stata

regress testscr str expn_stu el_pct, robust
test str=expn_stru 

**** Stesso risultato: Non posso rifiutare che il coefficiente di STR sia uguale al coefficiente di EXPN_STU 

********************************

** Funzioni di regressioni non lineari 

* Polinomiali in X 

generate avginc2=avginc*avginc
generate avging3=avginc^3

regress testscr avginc, robust
regress testscr avginc avginc2, robust
regress testscr avginc avginc2 avginc3, robust

test avginc2 avginc3

* in base al test di ipotesi congiunte H0: avginc2=0 e avginc3=0, rifiuto la relazione lineare tra testscr e avginc

* Funzioni logaritmiche di Y e/o X 

generate lavginc=log(avginc)
plot testscr lavginc
generate ltestscr=log(testscr)
scatter ltestscr lavginc 

* Funzione lin-log
regress testscr lavginc, robust 
* un incremento dell'1% in avginc  associato a un aumento di 0.36 punti nel test

* Funzione log-log 
regress ltestscr lavginc
* un aumento dell' 1% nel reddito  associato a un aumento dello 0.0554% nel punteggio del test

** Interazioni tra variabili indipendenti 

* interazioni tra due variabili binarie 

generate hiel= el_pct>=10
generate histr= str>=20
generate histr_hiel=hiel*histr

regress testscr histr hiel, robust
regress testscr histr hiel histr_hiel, robust

* interazioni tra una variabile continua e una binaria

generate str_hiel=str*hiel

regress testscr str hiel str_hiel, robust
* testo se le due rette di regressione coincidono: se l'intercetta e la pendenza sono uguali 
test hiel str_hiel
* si rifiuta l'ipotesi congiunta che intercetta (hiel) e pendenza (str_hiel) siano uguali


* interazioni tra due variabili continue 

generate str_elpct=str*el_pct

regress testscr str el_pct str_elpct, robust 
* test se la dimensione delle classi  statisticamente significativa
test str str_elpct
* si rifiuta l'ipotesi nulla che la dimensione delle classi non influisca sull'apprendimento (voto del test) 

* chiudiamo il file log
log close
